#version 140
#extension GL_EXT_gpu_shader4 : enable
// Yet Another Raytraced CylinderMod01.fsh by bananaboy
//https://www.shadertoy.com/view/lstGRn
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Ray starts at the origin and travels through the pixel in the positive z direction.
    vec3 rayDir = vec3(- 1.0 + 2.0 * (gl_FragCoord.xy / iResolution.xy), 1.0);
    rayDir = normalize(rayDir);
    
    // Cylinder is along the z axis with a radius of 1.0
    float cylinderRadius = 1.0;

    // Calculate intersection time along ray direction.
    float t = pow(cylinderRadius, 2.0) / dot(rayDir.xy, rayDir.xy);

    // Calculate intersection point.
    vec3 intersection = t * rayDir;

    // Calculate the angle of the intersection point in the x/y plane and use that as the texture U coordinate.
    // To map the texture once around the cylinder we should divide by PI but it's nicer to have some scaling.
    float theta = atan(intersection.y / intersection.x);

    // Use the intersection point z as the texture V coordinate.
    vec2 uv = vec2(theta, intersection.z);

    // Add time to the v to simulate motion.
    uv.y += iTime;

    // Calculate the distance of the fragment to the centre of the screen. We'll use it to darken the
    // texture sample to simulate depth cueing.
    float dist = length((gl_FragCoord.xy / iResolution.xy) - vec2(0.5, 0.5));

    // Look up the texture and scale it by the distance, and also by 2.0 to brighten it.
    vec4 tex = texture2D(iChannel0, uv) * dist * 2.0;

    gl_FragColor = vec4(tex.xyz, 1.0);
}
